'GSLITH
'PROGRAM TO STORE, RECALL AND PLOT DATA
'REGARDING THE LITHOLOGY ENCOUNTERED DOWN WELLS
'BASED ON AN LAT,LON SYSTEM
'
DEFSNG A-Z
OPTION BASE 1
DIM SHARED GEOG#(2),PROJ#(2),DARRAY#(9),DBWLL#(6,2),DBWXY#(6,2),DGW(4,2), _
	BedIdent$(250),TopOfBed(250),BottomOfBed(250),NUMB(250,5), _
	ValidBedIdents$(99),FillPats(99,5),HistPats(5,5), _
	NPEN%(5),NLT%(5),NBASE(5),NSCALE(5),PCT(12)
COMMON SHARED /LITH/GEOG#(),PROJ#(),DARRAY#(),DBWLL#(),DBWXY#(),DGW(), _
		BedIdent$(),TopOfBed(),BottomOfBed(),NUMB(),ValidBedIdents$(),_
		FillPats(),HistPats(),NPEN%(),NLT%(),NBASE(),NSCALE(),PCT(), _
		CM#,PTYP%,BedCnt%,STRAT$,RESBED1$,RESBED2$,DATUM,ECODE%, _
		SFILNAM$,PRJNAM$,TCODE%
FUNCTION CNVRAS%(XT!,XSHIFT!) STATIC
	CNVRAS%=XT!*1016!+50!-XSHIFT!
END FUNCTION
FUNCTION CNVPLT(XMAX,XMIN,MSCALE,ZOFF) STATIC
	CNVPLT=(((XMAX-XMIN)*12.)/MSCALE)+ZOFF
END FUNCTION
FUNCTION SNGMIN(A,B) STATIC
	SNGMIN=-B*(B<A)-A*(A<B)-A*(A=B)
END FUNCTION
FUNCTION SNGMAX(A,B) STATIC
	SNGMAX=-B*(B>A)-A*(A>B)-A*(A=B)
END FUNCTION
FUNCTION DBLMIN#(A#,B#) STATIC
	DBLMIN#=-B#*(B#<A#)-A#*(A#<B#)-A#*(A#=B#)
END FUNCTION
FUNCTION DBLMAX#(A#,B#) STATIC
	DBLMAX#=-B#*(B#>A#)-A#*(A#>B#)-A#*(A#=B#)
END FUNCTION
'
'INITIALIZE VARIABLES AND ARRAYS
'
	KEY OFF
	COLOR 15,1
	TCODE%=0
	ECODE%=0
	ON ERROR GOTO 7403
	OPEN "CONFIG.DIG" FOR INPUT AS #1
	ON ERROR GOTO 0
	CLOSE #1
	TCODE%=TCODE%+ECODE%
	ECODE%=0
	ON ERROR GOTO 7405
	OPEN "CONFIG.PLT" FOR INPUT AS #1
	ON ERROR GOTO 0
	CLOSE #1
	TCODE%=TCODE%+ECODE%
	IF TCODE%<>0 THEN
		PRINT "CANNOT FIND CONFIG.DIG OR CONFIG.PLT - STOPPING"
		GOTO 11000
	END IF
	DGR=.0174532925199433#
	SFILNAM$=""
	PRJNAM$=""
	IFO$="N"
	FMT1$="\                                  \    ######    ######    ######"
	FMT2$="\          \  ######.###  ######.##    ######    ######    ####    ###"
	FMT3$="                   \      \  #####.#    #####.#  ##.## ##.## ##.## ##.## ##.##"
	FMT4$="\          \  ######.###  ######.###  #####.##"
	FMT5$="\          \!  ####.###"
	FMT6$="                              NO BED RECORDS HAVE BEEN ENTERED"
	FMT7$="\          \ HAS BEEN DELETED"
	FMT10$="\ \  ######.###  ######.###  \ \  ######.###  ######.###"
	FMT11$="\          \! ######.###  ######.###  ## ###.## ###.## ###.## ###.## ###.##"
	WIDTH 80
	CLS
	LOCATE  4,29:PRINT "   G  S  L  I  T  H"
	LOCATE  6,29:PRINT "     Version 2.00"
	LOCATE  8,29:PRINT " Open File 89-114B"
	LOCATE 11,22:PRINT "Gary I. Selner and Richard B. Taylor"
	LOCATE 12,29:PRINT "U. S. Geological Survey"
	LOCATE 15,29:PRINT "     DISCLAIMER          "
	LOCATE 17,10:PRINT "Although program tests have been made, no guarantee (expressed";
	LOCATE 18,10:PRINT "or implied) is made by the author regarding program correctness,";
	LOCATE 19,10:PRINT "accuracy, or proper execution on all computer systems.";
	SLEEP(1)
	ON KEY(9) GOSUB 3500
	KEY(9) OFF
'
' Setup Main Menu
160	WIDTH 80
	CLS
	PRINT:PRINT:PRINT:PRINT
	PRINT "                 G  S  L  I  T  H            "
	PRINT "                                                         "
	PRINT "                                      CURRENT DATA BASE: "+DataBaseName$
	PRINT
	PRINT"  1  -  START A NEW DATA BASE"
	PRINT"  2  -  OPEN AN EXISTING DATA BASE"
	PRINT"  3  -  DIGITIZE NEW WELL LOCATIONS"
	PRINT"  4  -  DELETE A WELL"
	PRINT"  5  -  RECOVER A WELL"
	PRINT"  6  -  ENTER UNIT RECORDS FOR A WELL"
	PRINT"  7  -  EDIT UNIT RECORDS FOR A WELL"
	PRINT"  8  -  LIST CONTENTS OF DATA BASE"
	PRINT"  9  -  PLOT SECTION VIEW ON THE PLOTTER"
	PRINT" 10  -  PLOT PLAN VIEW ON THE PLOTTER(POSTING)"
	PRINT" 11  -  MERGE ANOTHER DATA BASE INTO CURRENT DATA BASE"
	PRINT" 12  -  EXIT"
	PRINT
	CALL TTINSI(22,1,"                                 ENTER CHOICE BY NUMBER: ", ICHOICE%,0,"Y")
	IF IFO$="N" AND (ICHOICE%>2 AND ICHOICE%<12) THEN
		CLS
		PRINT "You must start or open a DATA BASE before using options 3-11"
		LOCATE 24, 1
		PRINT "Press any key to continue.";
		IDUM$=INPUT$(1)
	ELSE
		IF ICHOICE%=1 THEN
			CALL StartADataBase(DataBaseName$)
			IF DataBaseName$<>"" THEN
				IFO$="Y"
			END IF
		END IF
		IF ICHOICE%=2 THEN
			CALL OpenADataBase(DataBaseName$)
			IF DataBaseName$<>"" THEN
				IFO$="Y"
			END IF
		END IF
		IF ICHOICE%=3 THEN CALL DigitizeLocations(DataBaseName$)
		IF ICHOICE%=4 THEN CALL DeleteAWell(DataBaseName$)
		IF ICHOICE%=5 THEN CALL RecoverAWell(DataBaseName$)
		IF ICHOICE%=6 THEN CALL EnterDetail(DataBaseName$)
		IF ICHOICE%=7 THEN CALL EditDetail(DataBaseName$)
		IF ICHOICE%=8 THEN CALL ListData(DataBaseName$)
		IF ICHOICE%=9 THEN CALL PlotSection(DataBaseName$)
		IF ICHOICE%=10 THEN CALL PlotPlan(DataBaseName$)
		IF ICHOICE%=11 THEN CALL MergeAnother(DataBaseName$)
		IF ICHOICE%=12 THEN GOTO 11000
	END IF
	GOTO 160
'trap on function key(9) to pause listing, plot to screen or plot to plotter
3500    TCODE%=0
	IDUM$=INPUT$(1)
	IDUM$=UCASE$(IDUM$)
	IF IDUM$="Q" THEN TCODE%=1
	RETURN
' ERROR ROUTINE FOR OPEN OF CONFIG.DIG FILE
7403	ECODE%=1
	PRINT "AN ERROR HAS OCCURRED OPENING DIGITIZER CONFIGURATION FILE"
	PRINT "(CONFIG.DIG)"
	RESUME NEXT
' ERROR ROUTINE FOR OPEN OF CONFIG.PLT FILE
7405	ECODE%=1
	PRINT "AN ERROR HAS OCCURRED OPENING PLOTTER CONFIGURATION FILE"
	PRINT "(CONFIG.PLT)"
	RESUME NEXT
'ERROR ROUTINE FOR OPENING UNIT IDENTIFIER FILE
7600:	PRINT "AN ERROR HAS OCCURRED OPENING UNIT IDENTIFIERS FILE ";SFILNAM$
	PRINT "CHECK FILENAME. HIT ANY KEY TO RETRY"
	IDUM$=INPUT$(1)
	ECODE%=1
	RESUME NEXT
11000	END
'
' Subroutine to load table of Valid Bed Identifiers and Fill Patterns
'
SUB LoadBedIdentifiers(BedCnt%,ValidBedIdents$(1),FillPats(2)) STATIC
	BedCnt%=1
LBID2:	IEOF%=EOF(5): IF IEOF%<0 GOTO LBID99
	INPUT #5,TEMP$,FillPats(BedCnt%,1), _
		FillPats(BedCnt%,2), FillPats(BedCnt%,3), _
		FillPats(BedCnt%,4), FillPats(BedCnt%,5)
	ValidBedIdents$(BedCnt%)=STRING$(8," ")
	K%=LEN(TEMP$)
	IF K%>8 THEN K%=8
	MID$(ValidBedIdents$(BedCnt%),1,K%)=TEMP$
	BedCnt%=BedCnt%+1
	GOTO LBID2
LBID99:	BedCnt%=BedCnt%-1
	CLOSE #5
END SUB
'
' Subroutine to check Bed Identifier against table of Valid Bed Identifiers
'
SUB CheckBedIdent(TEMP$,BedCnt%,ValidBedIdents$(1),IERR%) STATIC
	IERR%=0
	FOR IJK%=1 TO BedCnt%
		IF TEMP$=ValidBedIdents$(IJK%) GOTO CBID
	NEXT IJK%
	IERR%=1:BEEP
	PRINT "INVALID BED IDENTIFIER - RE-ENTER"
CBID:
END SUB
SUB GetBedFile(SFILNAM$) STATIC
751	CLS
	ECODE%=0
	CALL TTINAA(1,1,"Enter Filename for Valid Bed Identifiers: ",TEMP$,SFILNAM$,"Y")
	SFILNAM$=TEMP$
	IF SFILNAM$<>"" THEN
		ON ERROR GOTO 7600
		OPEN SFILNAM$ FOR INPUT AS #5
		ON ERROR GOTO 0
		IF ECODE%<>0 GOTO 751
		CALL LoadBedIdentifiers(BedCnt%,ValidBedIdents$(),FillPats())
	END IF
END SUB
SUB PAD(S1$,S2$,L%) STATIC
	S2$=STRING$(L%," ")
	K%=LEN(S1$)
	IF K%>L% THEN K%=L%
	IF K%>0 THEN
		MID$(S2$,1,K%)=S1$
	END IF
END SUB
SUB CON2FT(XKM#,YKM#,XFT#,YFT#) STATIC
	XFT#=XKM#*3280.84#
	YFT#=YKM#*3280.84#
END SUB
SUB LATDMS(DECDEG#,S$) STATIC
'
'SUBROUTINE TO CONVERT DOUBLE PRECISION DECIMAL DEGREES TO 
'12 CHARACTER STRING FOR PRINTING
'
	INTDEG%=FIX(ABS(DECDEG#))
	TEMP#=ABS(DECDEG#)-CDBL(INTDEG%)
	INTMIN%=FIX(TEMP#*60#)
	TEMP#=TEMP#*60#-CDBL(INTMIN%)
	SNGSEC!=CSNG(TEMP#*60#)
	IF SNGSEC! < .0001 THEN SNGSEC! = 0.0
	IF SNGSEC! >= 60! THEN INTMIN% = INTMIN% + 1: SNGSEC! = SNGSEC! -60
	IF INTMIN% >= 60  THEN INTDEG% = INTDEG% + 1: INTMIN% = INTMIN% - 60
	S$=SPACE$(12)
	TEMP$=MID$(STR$(INTDEG%),2,3):MID$(S$,1,3)=TEMP$
	TEMP$=MID$(STR$(INTMIN%),2,2):MID$(S$,5,2)=TEMP$
	TEMP$=MID$(STR$(SNGSEC!),2,5):MID$(S$,8,5)=TEMP$
	IF DECDEG#>=0 THEN
		S$=S$+" N"
	ELSE
		S$=S$+" S"
	END IF
END SUB
SUB LONDMS(DECDEG#,S$) STATIC
'
'SUBROUTINE TO CONVERT DOUBLE PRECISION DECIMAL DEGREES TO 
'12 CHARACTER STRING FOR PRINTING
'
	INTDEG%=FIX(ABS(DECDEG#))
	TEMP#=ABS(DECDEG#)-CDBL(INTDEG%)
	INTMIN%=FIX(TEMP#*60#)
	TEMP#=TEMP#*60#-CDBL(INTMIN%)
	SNGSEC!=CSNG(TEMP#*60#)
	IF SNGSEC! < .0001 THEN SNGSEC! = 0.0
	IF SNGSEC! >= 60! THEN INTMIN% = INTMIN% + 1: SNGSEC! = SNGSEC! -60
	IF INTMIN% >= 60  THEN INTDEG% = INTDEG% + 1: INTMIN% = INTMIN% - 60
	S$=SPACE$(12)
	TEMP$=MID$(STR$(INTDEG%),2,3):MID$(S$,1,3)=TEMP$
	TEMP$=MID$(STR$(INTMIN%),2,2):MID$(S$,5,2)=TEMP$
	TEMP$=MID$(STR$(SNGSEC!),2,5):MID$(S$,8,5)=TEMP$
	IF DECDEG#>=0 THEN
		S$=S$+" E"
	ELSE
		S$=S$+" W"
	END IF
END SUB
SUB TTINAA(R%,C%,QUERY$,RES$,DEFAULT$,CR$) STATIC
	CALL TTDISP(R%,C%,QUERY$,RES$,L%,CR$)
	IF L%=0 THEN
		RES$=DEFAULT$
	END IF
END SUB
SUB TTINSI(R%,C%,QUERY$,VALUE%,DEFAULT%,CR$) STATIC
	CALL TTDISP(R%,C%,QUERY$,RES$,L%,CR$)
	IF L%=0 THEN
		VALUE%=DEFAULT%
	ELSE
		VALUE%=VAL(RES$)
	END IF
END SUB
SUB TTINSR(R%,C%,QUERY$,VALUE!,DEFAULT!,CR$) STATIC
	CALL TTDISP(R%,C%,QUERY$,RES$,L%,CR$)
	IF L%=0 THEN
		VALUE!=DEFAULT!
	ELSE
		VALUE!=VAL(RES$)
	END IF
END SUB
SUB TTINSD(R%,C%,QUERY$,VALUE#,DEFAULT#,CR$) STATIC
	CALL TTDISP(R%,C%,QUERY$,RES$,L%,CR$)
	IF L%=0 THEN
		VALUE#=DEFAULT#
	ELSE
		VALUE#=VAL(RES$)
	END IF
END SUB
SUB TTDISP(R%,C%,QUERY$,RES$,L%,CR$) STATIC
	IF R%<>0 AND C%<>0 THEN
		LOCATE R%,C%
	END IF
	PRINT QUERY$;
	IF CR$="N" THEN
		INPUT ; RES$
	ELSE
		INPUT RES$
	END IF
	L%=LEN(RES$)
END SUB
